package zio.aws.storagegateway
import zio.aws.storagegateway.model.primitives.{
  Host,
  UserListUser,
  TapeARN,
  FileShareARN,
  VolumeARN,
  DiskId,
  PoolARN,
  VTLDeviceARN,
  FileSystemAssociationARN,
  DayOfWeek,
  IPV4AddressCIDR,
  DiskAttribute,
  IPV4Address,
  Folder,
  Initiator,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActivationKey extends Subtype[String]
    type ActivationKey =
      zio.aws.storagegateway.model.primitives.ActivationKey.Type
    object AuditDestinationARN extends Subtype[String]
    type AuditDestinationARN =
      zio.aws.storagegateway.model.primitives.AuditDestinationARN.Type
    object Authentication extends Subtype[String]
    type Authentication =
      zio.aws.storagegateway.model.primitives.Authentication.Type
    object BandwidthDownloadRateLimit extends Subtype[Long]
    type BandwidthDownloadRateLimit =
      zio.aws.storagegateway.model.primitives.BandwidthDownloadRateLimit.Type
    object BandwidthType extends Subtype[String]
    type BandwidthType =
      zio.aws.storagegateway.model.primitives.BandwidthType.Type
    object BandwidthUploadRateLimit extends Subtype[Long]
    type BandwidthUploadRateLimit =
      zio.aws.storagegateway.model.primitives.BandwidthUploadRateLimit.Type
    object CacheStaleTimeoutInSeconds extends Subtype[Int]
    type CacheStaleTimeoutInSeconds =
      zio.aws.storagegateway.model.primitives.CacheStaleTimeoutInSeconds.Type
    object ChapSecret extends Subtype[String]
    type ChapSecret = zio.aws.storagegateway.model.primitives.ChapSecret.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.storagegateway.model.primitives.ClientToken.Type
    object CloudWatchLogGroupARN extends Subtype[String]
    type CloudWatchLogGroupARN =
      zio.aws.storagegateway.model.primitives.CloudWatchLogGroupARN.Type
    object CreatedDate extends Subtype[Instant]
    type CreatedDate = zio.aws.storagegateway.model.primitives.CreatedDate.Type
    object DNSHostName extends Subtype[String]
    type DNSHostName = zio.aws.storagegateway.model.primitives.DNSHostName.Type
    object DayOfMonth extends Subtype[Int]
    type DayOfMonth = zio.aws.storagegateway.model.primitives.DayOfMonth.Type
    object DayOfWeek extends Subtype[Int]
    type DayOfWeek = zio.aws.storagegateway.model.primitives.DayOfWeek.Type
    object DeprecationDate extends Subtype[String]
    type DeprecationDate =
      zio.aws.storagegateway.model.primitives.DeprecationDate.Type
    object Description extends Subtype[String]
    type Description = zio.aws.storagegateway.model.primitives.Description.Type
    object DeviceType extends Subtype[String]
    type DeviceType = zio.aws.storagegateway.model.primitives.DeviceType.Type
    object DiskAllocationType extends Subtype[String]
    type DiskAllocationType =
      zio.aws.storagegateway.model.primitives.DiskAllocationType.Type
    object DiskAttribute extends Subtype[String]
    type DiskAttribute =
      zio.aws.storagegateway.model.primitives.DiskAttribute.Type
    object DiskId extends Subtype[String]
    type DiskId = zio.aws.storagegateway.model.primitives.DiskId.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.storagegateway.model.primitives.DomainName.Type
    object DomainUserName extends Subtype[String]
    type DomainUserName =
      zio.aws.storagegateway.model.primitives.DomainUserName.Type
    object DomainUserPassword extends Subtype[String]
    type DomainUserPassword =
      zio.aws.storagegateway.model.primitives.DomainUserPassword.Type
    type DoubleObject = Double
    object Ec2InstanceId extends Subtype[String]
    type Ec2InstanceId =
      zio.aws.storagegateway.model.primitives.Ec2InstanceId.Type
    object Ec2InstanceRegion extends Subtype[String]
    type Ec2InstanceRegion =
      zio.aws.storagegateway.model.primitives.Ec2InstanceRegion.Type
    object EndpointType extends Subtype[String]
    type EndpointType =
      zio.aws.storagegateway.model.primitives.EndpointType.Type
    object FileShareARN extends Subtype[String]
    type FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN.Type
    object FileShareId extends Subtype[String]
    type FileShareId = zio.aws.storagegateway.model.primitives.FileShareId.Type
    object FileShareName extends Subtype[String]
    type FileShareName =
      zio.aws.storagegateway.model.primitives.FileShareName.Type
    object FileShareStatus extends Subtype[String]
    type FileShareStatus =
      zio.aws.storagegateway.model.primitives.FileShareStatus.Type
    object FileSystemAssociationARN extends Subtype[String]
    type FileSystemAssociationARN =
      zio.aws.storagegateway.model.primitives.FileSystemAssociationARN.Type
    object FileSystemAssociationId extends Subtype[String]
    type FileSystemAssociationId =
      zio.aws.storagegateway.model.primitives.FileSystemAssociationId.Type
    object FileSystemAssociationStatus extends Subtype[String]
    type FileSystemAssociationStatus =
      zio.aws.storagegateway.model.primitives.FileSystemAssociationStatus.Type
    object FileSystemAssociationSyncErrorCode extends Subtype[String]
    type FileSystemAssociationSyncErrorCode =
      zio.aws.storagegateway.model.primitives.FileSystemAssociationSyncErrorCode.Type
    object FileSystemLocationARN extends Subtype[String]
    type FileSystemLocationARN =
      zio.aws.storagegateway.model.primitives.FileSystemLocationARN.Type
    object Folder extends Subtype[String]
    type Folder = zio.aws.storagegateway.model.primitives.Folder.Type
    object GatewayARN extends Subtype[String]
    type GatewayARN = zio.aws.storagegateway.model.primitives.GatewayARN.Type
    object GatewayId extends Subtype[String]
    type GatewayId = zio.aws.storagegateway.model.primitives.GatewayId.Type
    object GatewayName extends Subtype[String]
    type GatewayName = zio.aws.storagegateway.model.primitives.GatewayName.Type
    object GatewayOperationalState extends Subtype[String]
    type GatewayOperationalState =
      zio.aws.storagegateway.model.primitives.GatewayOperationalState.Type
    object GatewayState extends Subtype[String]
    type GatewayState =
      zio.aws.storagegateway.model.primitives.GatewayState.Type
    object GatewayTimezone extends Subtype[String]
    type GatewayTimezone =
      zio.aws.storagegateway.model.primitives.GatewayTimezone.Type
    object GatewayType extends Subtype[String]
    type GatewayType = zio.aws.storagegateway.model.primitives.GatewayType.Type
    object Host extends Subtype[String]
    type Host = zio.aws.storagegateway.model.primitives.Host.Type
    object HostEnvironmentId extends Subtype[String]
    type HostEnvironmentId =
      zio.aws.storagegateway.model.primitives.HostEnvironmentId.Type
    object HourOfDay extends Subtype[Int]
    type HourOfDay = zio.aws.storagegateway.model.primitives.HourOfDay.Type
    object IPV4Address extends Subtype[String]
    type IPV4Address = zio.aws.storagegateway.model.primitives.IPV4Address.Type
    object IPV4AddressCIDR extends Subtype[String]
    type IPV4AddressCIDR =
      zio.aws.storagegateway.model.primitives.IPV4AddressCIDR.Type
    object Initiator extends Subtype[String]
    type Initiator = zio.aws.storagegateway.model.primitives.Initiator.Type
    type Integer = Int
    object IqnName extends Subtype[String]
    type IqnName = zio.aws.storagegateway.model.primitives.IqnName.Type
    object KMSKey extends Subtype[String]
    type KMSKey = zio.aws.storagegateway.model.primitives.KMSKey.Type
    object LastSoftwareUpdate extends Subtype[String]
    type LastSoftwareUpdate =
      zio.aws.storagegateway.model.primitives.LastSoftwareUpdate.Type
    object LocalConsolePassword extends Subtype[String]
    type LocalConsolePassword =
      zio.aws.storagegateway.model.primitives.LocalConsolePassword.Type
    object LocationARN extends Subtype[String]
    type LocationARN = zio.aws.storagegateway.model.primitives.LocationARN.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.storagegateway.model.primitives.Marker.Type
    object MediumChangerType extends Subtype[String]
    type MediumChangerType =
      zio.aws.storagegateway.model.primitives.MediumChangerType.Type
    object MinimumNumTapes extends Subtype[Int]
    type MinimumNumTapes =
      zio.aws.storagegateway.model.primitives.MinimumNumTapes.Type
    object MinuteOfHour extends Subtype[Int]
    type MinuteOfHour =
      zio.aws.storagegateway.model.primitives.MinuteOfHour.Type
    object NetworkInterfaceId extends Subtype[String]
    type NetworkInterfaceId =
      zio.aws.storagegateway.model.primitives.NetworkInterfaceId.Type
    object NextUpdateAvailabilityDate extends Subtype[String]
    type NextUpdateAvailabilityDate =
      zio.aws.storagegateway.model.primitives.NextUpdateAvailabilityDate.Type
    object NotificationId extends Subtype[String]
    type NotificationId =
      zio.aws.storagegateway.model.primitives.NotificationId.Type
    object NotificationPolicy extends Subtype[String]
    type NotificationPolicy =
      zio.aws.storagegateway.model.primitives.NotificationPolicy.Type
    object NumTapesToCreate extends Subtype[Int]
    type NumTapesToCreate =
      zio.aws.storagegateway.model.primitives.NumTapesToCreate.Type
    object OrganizationalUnit extends Subtype[String]
    type OrganizationalUnit =
      zio.aws.storagegateway.model.primitives.OrganizationalUnit.Type
    object Path extends Subtype[String]
    type Path = zio.aws.storagegateway.model.primitives.Path.Type
    object PermissionId extends Subtype[Long]
    type PermissionId =
      zio.aws.storagegateway.model.primitives.PermissionId.Type
    object PermissionMode extends Subtype[String]
    type PermissionMode =
      zio.aws.storagegateway.model.primitives.PermissionMode.Type
    object PoolARN extends Subtype[String]
    type PoolARN = zio.aws.storagegateway.model.primitives.PoolARN.Type
    object PoolId extends Subtype[String]
    type PoolId = zio.aws.storagegateway.model.primitives.PoolId.Type
    object PoolName extends Subtype[String]
    type PoolName = zio.aws.storagegateway.model.primitives.PoolName.Type
    object PositiveIntObject extends Subtype[Int]
    type PositiveIntObject =
      zio.aws.storagegateway.model.primitives.PositiveIntObject.Type
    object RecurrenceInHours extends Subtype[Int]
    type RecurrenceInHours =
      zio.aws.storagegateway.model.primitives.RecurrenceInHours.Type
    object RegionId extends Subtype[String]
    type RegionId = zio.aws.storagegateway.model.primitives.RegionId.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.storagegateway.model.primitives.ResourceARN.Type
    object RetentionLockTimeInDays extends Subtype[Int]
    type RetentionLockTimeInDays =
      zio.aws.storagegateway.model.primitives.RetentionLockTimeInDays.Type
    object Role extends Subtype[String]
    type Role = zio.aws.storagegateway.model.primitives.Role.Type
    object SMBGuestPassword extends Subtype[String]
    type SMBGuestPassword =
      zio.aws.storagegateway.model.primitives.SMBGuestPassword.Type
    object SnapshotDescription extends Subtype[String]
    type SnapshotDescription =
      zio.aws.storagegateway.model.primitives.SnapshotDescription.Type
    object SnapshotId extends Subtype[String]
    type SnapshotId = zio.aws.storagegateway.model.primitives.SnapshotId.Type
    object SoftwareUpdatesEndDate extends Subtype[String]
    type SoftwareUpdatesEndDate =
      zio.aws.storagegateway.model.primitives.SoftwareUpdatesEndDate.Type
    object Squash extends Subtype[String]
    type Squash = zio.aws.storagegateway.model.primitives.Squash.Type
    object StorageClass extends Subtype[String]
    type StorageClass =
      zio.aws.storagegateway.model.primitives.StorageClass.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.storagegateway.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.storagegateway.model.primitives.TagValue.Type
    object TapeARN extends Subtype[String]
    type TapeARN = zio.aws.storagegateway.model.primitives.TapeARN.Type
    object TapeArchiveStatus extends Subtype[String]
    type TapeArchiveStatus =
      zio.aws.storagegateway.model.primitives.TapeArchiveStatus.Type
    object TapeBarcode extends Subtype[String]
    type TapeBarcode = zio.aws.storagegateway.model.primitives.TapeBarcode.Type
    object TapeBarcodePrefix extends Subtype[String]
    type TapeBarcodePrefix =
      zio.aws.storagegateway.model.primitives.TapeBarcodePrefix.Type
    object TapeDriveType extends Subtype[String]
    type TapeDriveType =
      zio.aws.storagegateway.model.primitives.TapeDriveType.Type
    object TapeRecoveryPointStatus extends Subtype[String]
    type TapeRecoveryPointStatus =
      zio.aws.storagegateway.model.primitives.TapeRecoveryPointStatus.Type
    object TapeSize extends Subtype[Long]
    type TapeSize = zio.aws.storagegateway.model.primitives.TapeSize.Type
    object TapeStatus extends Subtype[String]
    type TapeStatus = zio.aws.storagegateway.model.primitives.TapeStatus.Type
    object TapeUsage extends Subtype[Long]
    type TapeUsage = zio.aws.storagegateway.model.primitives.TapeUsage.Type
    object TargetARN extends Subtype[String]
    type TargetARN = zio.aws.storagegateway.model.primitives.TargetARN.Type
    object TargetName extends Subtype[String]
    type TargetName = zio.aws.storagegateway.model.primitives.TargetName.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.storagegateway.model.primitives.Time.Type
    object TimeoutInSeconds extends Subtype[Int]
    type TimeoutInSeconds =
      zio.aws.storagegateway.model.primitives.TimeoutInSeconds.Type
    object UserListUser extends Subtype[String]
    type UserListUser =
      zio.aws.storagegateway.model.primitives.UserListUser.Type
    object VTLDeviceARN extends Subtype[String]
    type VTLDeviceARN =
      zio.aws.storagegateway.model.primitives.VTLDeviceARN.Type
    object VTLDeviceProductIdentifier extends Subtype[String]
    type VTLDeviceProductIdentifier =
      zio.aws.storagegateway.model.primitives.VTLDeviceProductIdentifier.Type
    object VTLDeviceType extends Subtype[String]
    type VTLDeviceType =
      zio.aws.storagegateway.model.primitives.VTLDeviceType.Type
    object VTLDeviceVendor extends Subtype[String]
    type VTLDeviceVendor =
      zio.aws.storagegateway.model.primitives.VTLDeviceVendor.Type
    object VolumeARN extends Subtype[String]
    type VolumeARN = zio.aws.storagegateway.model.primitives.VolumeARN.Type
    object VolumeAttachmentStatus extends Subtype[String]
    type VolumeAttachmentStatus =
      zio.aws.storagegateway.model.primitives.VolumeAttachmentStatus.Type
    object VolumeId extends Subtype[String]
    type VolumeId = zio.aws.storagegateway.model.primitives.VolumeId.Type
    object VolumeStatus extends Subtype[String]
    type VolumeStatus =
      zio.aws.storagegateway.model.primitives.VolumeStatus.Type
    object VolumeType extends Subtype[String]
    type VolumeType = zio.aws.storagegateway.model.primitives.VolumeType.Type
    object VolumeUsedInBytes extends Subtype[Long]
    type VolumeUsedInBytes =
      zio.aws.storagegateway.model.primitives.VolumeUsedInBytes.Type
  }
  type AutomaticTapeCreationPolicyInfos =
    List[zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo]
  type AutomaticTapeCreationRules =
    List[zio.aws.storagegateway.model.AutomaticTapeCreationRule]
  type BandwidthRateLimitIntervals =
    List[zio.aws.storagegateway.model.BandwidthRateLimitInterval]
  type CachediSCSIVolumes = List[zio.aws.storagegateway.model.CachediSCSIVolume]
  type ChapCredentials = List[zio.aws.storagegateway.model.ChapInfo]
  type DaysOfWeek = List[DayOfWeek]
  type DiskAttributeList = List[DiskAttribute]
  type DiskIds = List[DiskId]
  type Disks = List[zio.aws.storagegateway.model.Disk]
  type FileShareARNList = List[FileShareARN]
  type FileShareClientList = List[IPV4AddressCIDR]
  type FileShareInfoList = List[zio.aws.storagegateway.model.FileShareInfo]
  type FileSystemAssociationARNList = List[FileSystemAssociationARN]
  type FileSystemAssociationInfoList =
    List[zio.aws.storagegateway.model.FileSystemAssociationInfo]
  type FileSystemAssociationStatusDetails =
    List[zio.aws.storagegateway.model.FileSystemAssociationStatusDetail]
  type FileSystemAssociationSummaryList =
    List[zio.aws.storagegateway.model.FileSystemAssociationSummary]
  type FolderList = List[Folder]
  type GatewayNetworkInterfaces =
    List[zio.aws.storagegateway.model.NetworkInterface]
  type Gateways = List[zio.aws.storagegateway.model.GatewayInfo]
  type Hosts = List[Host]
  type Initiators = List[Initiator]
  type IpAddressList = List[IPV4Address]
  type NFSFileShareInfoList =
    List[zio.aws.storagegateway.model.NFSFileShareInfo]
  type PoolARNs = List[PoolARN]
  type PoolInfos = List[zio.aws.storagegateway.model.PoolInfo]
  type SMBFileShareInfoList =
    List[zio.aws.storagegateway.model.SMBFileShareInfo]
  type StorediSCSIVolumes = List[zio.aws.storagegateway.model.StorediSCSIVolume]
  type SupportedGatewayCapacities =
    List[zio.aws.storagegateway.model.GatewayCapacity]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.storagegateway.model.Tag]
  type TapeARNs = List[TapeARN]
  type TapeArchives = List[zio.aws.storagegateway.model.TapeArchive]
  type TapeInfos = List[zio.aws.storagegateway.model.TapeInfo]
  type TapeRecoveryPointInfos =
    List[zio.aws.storagegateway.model.TapeRecoveryPointInfo]
  type Tapes = List[zio.aws.storagegateway.model.Tape]
  type UserList = List[UserListUser]
  type VTLDeviceARNs = List[VTLDeviceARN]
  type VTLDevices = List[zio.aws.storagegateway.model.VTLDevice]
  type VolumeARNs = List[VolumeARN]
  type VolumeInfos = List[zio.aws.storagegateway.model.VolumeInfo]
  type VolumeRecoveryPointInfos =
    List[zio.aws.storagegateway.model.VolumeRecoveryPointInfo]
}
