package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileShareResponse(
    fileShareARN: Optional[FileShareARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse = {
    import DeleteFileShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteFileShareResponse.wrap(buildAwsValue())
}
object DeleteFileShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteFileShareResponse =
      zio.aws.storagegateway.model
        .DeleteFileShareResponse(fileShareARN.map(value => value))
    def fileShareARN: Optional[FileShareARN]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse
  ) extends zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse
  ): zio.aws.storagegateway.model.DeleteFileShareResponse.ReadOnly =
    new Wrapper(impl)
}
