package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetLocalConsolePasswordResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse = {
    import SetLocalConsolePasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly =
    zio.aws.storagegateway.model.SetLocalConsolePasswordResponse
      .wrap(buildAwsValue())
}
object SetLocalConsolePasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.SetLocalConsolePasswordResponse =
      zio.aws.storagegateway.model
        .SetLocalConsolePasswordResponse(gatewayARN.map(value => value))
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse
  ) extends zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse
  ): zio.aws.storagegateway.model.SetLocalConsolePasswordResponse.ReadOnly =
    new Wrapper(impl)
}
