package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVolumeResponse(
    volumeARN: Optional[VolumeARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse = {
    import DeleteVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteVolumeResponse.wrap(buildAwsValue())
}
object DeleteVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteVolumeResponse =
      zio.aws.storagegateway.model
        .DeleteVolumeResponse(volumeARN.map(value => value))
    def volumeARN: Optional[VolumeARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse
  ) extends zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse
  ): zio.aws.storagegateway.model.DeleteVolumeResponse.ReadOnly = new Wrapper(
    impl
  )
}
