package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters._
sealed trait RetentionLockType {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.RetentionLockType
}
object RetentionLockType {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.RetentionLockType
  ): zio.aws.storagegateway.model.RetentionLockType = value match {
    case software.amazon.awssdk.services.storagegateway.model.RetentionLockType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.RetentionLockType.COMPLIANCE =>
      val r = COMPLIANCE
      r
    case software.amazon.awssdk.services.storagegateway.model.RetentionLockType.GOVERNANCE =>
      val r = GOVERNANCE
      r
    case software.amazon.awssdk.services.storagegateway.model.RetentionLockType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.RetentionLockType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.RetentionLockType =
      software.amazon.awssdk.services.storagegateway.model.RetentionLockType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANCE
      extends zio.aws.storagegateway.model.RetentionLockType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.RetentionLockType =
      software.amazon.awssdk.services.storagegateway.model.RetentionLockType.COMPLIANCE
  }
  case object GOVERNANCE
      extends zio.aws.storagegateway.model.RetentionLockType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.RetentionLockType =
      software.amazon.awssdk.services.storagegateway.model.RetentionLockType.GOVERNANCE
  }
  case object NONE extends zio.aws.storagegateway.model.RetentionLockType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.RetentionLockType =
      software.amazon.awssdk.services.storagegateway.model.RetentionLockType.NONE
  }
}
