package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DomainName, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSmbSettingsResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    activeDirectoryStatus: Optional[
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] = Optional.Absent,
    smbGuestPasswordSet: Optional[Boolean] = Optional.Absent,
    smbSecurityStrategy: Optional[
      zio.aws.storagegateway.model.SMBSecurityStrategy
    ] = Optional.Absent,
    fileSharesVisible: Optional[Boolean] = Optional.Absent,
    smbLocalGroups: Optional[zio.aws.storagegateway.model.SMBLocalGroups] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse = {
    import DescribeSmbSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(activeDirectoryStatus.map(value => value.unwrap))(
        _.activeDirectoryStatus
      )
      .optionallyWith(
        smbGuestPasswordSet.map(value => value: java.lang.Boolean)
      )(_.smbGuestPasswordSet)
      .optionallyWith(smbSecurityStrategy.map(value => value.unwrap))(
        _.smbSecurityStrategy
      )
      .optionallyWith(fileSharesVisible.map(value => value: java.lang.Boolean))(
        _.fileSharesVisible
      )
      .optionallyWith(smbLocalGroups.map(value => value.buildAwsValue()))(
        _.smbLocalGroups
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeSmbSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeSmbSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeSmbSettingsResponse =
      zio.aws.storagegateway.model.DescribeSmbSettingsResponse(
        gatewayARN.map(value => value),
        domainName.map(value => value),
        activeDirectoryStatus.map(value => value),
        smbGuestPasswordSet.map(value => value),
        smbSecurityStrategy.map(value => value),
        fileSharesVisible.map(value => value),
        smbLocalGroups.map(value => value.asEditable)
      )
    def gatewayARN: Optional[GatewayARN]
    def domainName: Optional[DomainName]
    def activeDirectoryStatus
        : Optional[zio.aws.storagegateway.model.ActiveDirectoryStatus]
    def smbGuestPasswordSet: Optional[Boolean]
    def smbSecurityStrategy
        : Optional[zio.aws.storagegateway.model.SMBSecurityStrategy]
    def fileSharesVisible: Optional[Boolean]
    def smbLocalGroups
        : Optional[zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getActiveDirectoryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.ActiveDirectoryStatus
    ] =
      AwsError.unwrapOptionField("activeDirectoryStatus", activeDirectoryStatus)
    def getSmbGuestPasswordSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smbGuestPasswordSet", smbGuestPasswordSet)
    def getSmbSecurityStrategy
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.SMBSecurityStrategy] =
      AwsError.unwrapOptionField("smbSecurityStrategy", smbSecurityStrategy)
    def getFileSharesVisible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fileSharesVisible", fileSharesVisible)
    def getSmbLocalGroups: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly
    ] = AwsError.unwrapOptionField("smbLocalGroups", smbLocalGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ) extends zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.storagegateway.model.primitives.DomainName(value))
    override val activeDirectoryStatus
        : Optional[zio.aws.storagegateway.model.ActiveDirectoryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryStatus())
        .map(value =>
          zio.aws.storagegateway.model.ActiveDirectoryStatus.wrap(value)
        )
    override val smbGuestPasswordSet: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.smbGuestPasswordSet())
      .map(value => value: Boolean)
    override val smbSecurityStrategy
        : Optional[zio.aws.storagegateway.model.SMBSecurityStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smbSecurityStrategy())
        .map(value =>
          zio.aws.storagegateway.model.SMBSecurityStrategy.wrap(value)
        )
    override val fileSharesVisible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSharesVisible())
      .map(value => value: Boolean)
    override val smbLocalGroups
        : Optional[zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smbLocalGroups())
        .map(value => zio.aws.storagegateway.model.SMBLocalGroups.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse
  ): zio.aws.storagegateway.model.DescribeSmbSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
