package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{IqnName, ChapSecret, TargetARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChapInfo(
    targetARN: Optional[TargetARN] = Optional.Absent,
    secretToAuthenticateInitiator: Optional[ChapSecret] = Optional.Absent,
    initiatorName: Optional[IqnName] = Optional.Absent,
    secretToAuthenticateTarget: Optional[ChapSecret] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ChapInfo = {
    import ChapInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ChapInfo
      .builder()
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .optionallyWith(
        secretToAuthenticateInitiator.map(value =>
          ChapSecret.unwrap(value): java.lang.String
        )
      )(_.secretToAuthenticateInitiator)
      .optionallyWith(
        initiatorName.map(value => IqnName.unwrap(value): java.lang.String)
      )(_.initiatorName)
      .optionallyWith(
        secretToAuthenticateTarget.map(value =>
          ChapSecret.unwrap(value): java.lang.String
        )
      )(_.secretToAuthenticateTarget)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ChapInfo.ReadOnly =
    zio.aws.storagegateway.model.ChapInfo.wrap(buildAwsValue())
}
object ChapInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ChapInfo =
      zio.aws.storagegateway.model.ChapInfo(
        targetARN.map(value => value),
        secretToAuthenticateInitiator.map(value => value),
        initiatorName.map(value => value),
        secretToAuthenticateTarget.map(value => value)
      )
    def targetARN: Optional[TargetARN]
    def secretToAuthenticateInitiator: Optional[ChapSecret]
    def initiatorName: Optional[IqnName]
    def secretToAuthenticateTarget: Optional[ChapSecret]
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
    def getSecretToAuthenticateInitiator: ZIO[Any, AwsError, ChapSecret] =
      AwsError.unwrapOptionField(
        "secretToAuthenticateInitiator",
        secretToAuthenticateInitiator
      )
    def getInitiatorName: ZIO[Any, AwsError, IqnName] =
      AwsError.unwrapOptionField("initiatorName", initiatorName)
    def getSecretToAuthenticateTarget: ZIO[Any, AwsError, ChapSecret] =
      AwsError.unwrapOptionField(
        "secretToAuthenticateTarget",
        secretToAuthenticateTarget
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ) extends zio.aws.storagegateway.model.ChapInfo.ReadOnly {
    override val targetARN: Optional[TargetARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
    override val secretToAuthenticateInitiator: Optional[ChapSecret] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretToAuthenticateInitiator())
        .map(value => zio.aws.storagegateway.model.primitives.ChapSecret(value))
    override val initiatorName: Optional[IqnName] = zio.aws.core.internal
      .optionalFromNullable(impl.initiatorName())
      .map(value => zio.aws.storagegateway.model.primitives.IqnName(value))
    override val secretToAuthenticateTarget: Optional[ChapSecret] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretToAuthenticateTarget())
        .map(value => zio.aws.storagegateway.model.primitives.ChapSecret(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ChapInfo
  ): zio.aws.storagegateway.model.ChapInfo.ReadOnly = new Wrapper(impl)
}
