package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{GatewayARN, TapeARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RetrieveTapeRecoveryPointRequest(
    tapeARN: TapeARN,
    gatewayARN: GatewayARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest = {
    import RetrieveTapeRecoveryPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest
      .builder()
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest.ReadOnly =
    zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest
      .wrap(buildAwsValue())
}
object RetrieveTapeRecoveryPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest =
      zio.aws.storagegateway.model
        .RetrieveTapeRecoveryPointRequest(tapeARN, gatewayARN)
    def tapeARN: TapeARN
    def gatewayARN: GatewayARN
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest
  ) extends zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest.ReadOnly {
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest
  ): zio.aws.storagegateway.model.RetrieveTapeRecoveryPointRequest.ReadOnly =
    new Wrapper(impl)
}
