package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeRecoveryPointInfo(
    volumeARN: Optional[VolumeARN] = Optional.Absent,
    volumeSizeInBytes: Optional[Long] = Optional.Absent,
    volumeUsageInBytes: Optional[Long] = Optional.Absent,
    volumeRecoveryPointTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo = {
    import VolumeRecoveryPointInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(volumeUsageInBytes.map(value => value: java.lang.Long))(
        _.volumeUsageInBytes
      )
      .optionallyWith(
        volumeRecoveryPointTime.map(value => value: java.lang.String)
      )(_.volumeRecoveryPointTime)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly =
    zio.aws.storagegateway.model.VolumeRecoveryPointInfo.wrap(buildAwsValue())
}
object VolumeRecoveryPointInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VolumeRecoveryPointInfo =
      zio.aws.storagegateway.model.VolumeRecoveryPointInfo(
        volumeARN.map(value => value),
        volumeSizeInBytes.map(value => value),
        volumeUsageInBytes.map(value => value),
        volumeRecoveryPointTime.map(value => value)
      )
    def volumeARN: Optional[VolumeARN]
    def volumeSizeInBytes: Optional[Long]
    def volumeUsageInBytes: Optional[Long]
    def volumeRecoveryPointTime: Optional[String]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getVolumeUsageInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeUsageInBytes", volumeUsageInBytes)
    def getVolumeRecoveryPointTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("volumeRecoveryPointTime", volumeRecoveryPointTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo
  ) extends zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInBytes())
      .map(value => value: Long)
    override val volumeUsageInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeUsageInBytes())
      .map(value => value: Long)
    override val volumeRecoveryPointTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeRecoveryPointTime())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo
  ): zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly =
    new Wrapper(impl)
}
