package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RetrieveTapeRecoveryPointResponse(
    tapeARN: Optional[TapeARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse = {
    import RetrieveTapeRecoveryPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly =
    zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse
      .wrap(buildAwsValue())
}
object RetrieveTapeRecoveryPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse =
      zio.aws.storagegateway.model
        .RetrieveTapeRecoveryPointResponse(tapeARN.map(value => value))
    def tapeARN: Optional[TapeARN]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse
  ) extends zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly {
    override val tapeARN: Optional[TapeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse
  ): zio.aws.storagegateway.model.RetrieveTapeRecoveryPointResponse.ReadOnly =
    new Wrapper(impl)
}
