package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotScheduleRequest(volumeARN: VolumeARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest = {
    import DescribeSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest
      .wrap(buildAwsValue())
}
object DescribeSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest =
      zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest(volumeARN)
    def volumeARN: VolumeARN
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest
  ) extends zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest
  ): zio.aws.storagegateway.model.DescribeSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
