package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBandwidthRateLimitScheduleResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    bandwidthRateLimitIntervals: Optional[
      Iterable[zio.aws.storagegateway.model.BandwidthRateLimitInterval]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse = {
    import DescribeBandwidthRateLimitScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        bandwidthRateLimitIntervals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bandwidthRateLimitIntervals)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
      .wrap(buildAwsValue())
}
object DescribeBandwidthRateLimitScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse =
      zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse(
        gatewayARN.map(value => value),
        bandwidthRateLimitIntervals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: Optional[GatewayARN]
    def bandwidthRateLimitIntervals: Optional[
      List[zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly]
    ]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getBandwidthRateLimitIntervals: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "bandwidthRateLimitIntervals",
      bandwidthRateLimitIntervals
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
  ) extends zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val bandwidthRateLimitIntervals: Optional[
      List[zio.aws.storagegateway.model.BandwidthRateLimitInterval.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bandwidthRateLimitIntervals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.BandwidthRateLimitInterval.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
  ): zio.aws.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
