package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  Marker,
  PositiveIntObject,
  GatewayARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFileSystemAssociationsRequest(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest = {
    import ListFileSystemAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly =
    zio.aws.storagegateway.model.ListFileSystemAssociationsRequest
      .wrap(buildAwsValue())
}
object ListFileSystemAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListFileSystemAssociationsRequest =
      zio.aws.storagegateway.model.ListFileSystemAssociationsRequest(
        gatewayARN.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def limit: Optional[PositiveIntObject]
    def marker: Optional[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ) extends zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest
  ): zio.aws.storagegateway.model.ListFileSystemAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
