package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  VTLDeviceProductIdentifier,
  VTLDeviceVendor,
  VTLDeviceType,
  VTLDeviceARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VTLDevice(
    vtlDeviceARN: Optional[VTLDeviceARN] = Optional.Absent,
    vtlDeviceType: Optional[VTLDeviceType] = Optional.Absent,
    vtlDeviceVendor: Optional[VTLDeviceVendor] = Optional.Absent,
    vtlDeviceProductIdentifier: Optional[VTLDeviceProductIdentifier] =
      Optional.Absent,
    deviceiSCSIAttributes: Optional[
      zio.aws.storagegateway.model.DeviceiSCSIAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VTLDevice = {
    import VTLDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VTLDevice
      .builder()
      .optionallyWith(
        vtlDeviceARN.map(value => VTLDeviceARN.unwrap(value): java.lang.String)
      )(_.vtlDeviceARN)
      .optionallyWith(
        vtlDeviceType.map(value =>
          VTLDeviceType.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceType)
      .optionallyWith(
        vtlDeviceVendor.map(value =>
          VTLDeviceVendor.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceVendor)
      .optionallyWith(
        vtlDeviceProductIdentifier.map(value =>
          VTLDeviceProductIdentifier.unwrap(value): java.lang.String
        )
      )(_.vtlDeviceProductIdentifier)
      .optionallyWith(
        deviceiSCSIAttributes.map(value => value.buildAwsValue())
      )(_.deviceiSCSIAttributes)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VTLDevice.ReadOnly =
    zio.aws.storagegateway.model.VTLDevice.wrap(buildAwsValue())
}
object VTLDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VTLDevice =
      zio.aws.storagegateway.model.VTLDevice(
        vtlDeviceARN.map(value => value),
        vtlDeviceType.map(value => value),
        vtlDeviceVendor.map(value => value),
        vtlDeviceProductIdentifier.map(value => value),
        deviceiSCSIAttributes.map(value => value.asEditable)
      )
    def vtlDeviceARN: Optional[VTLDeviceARN]
    def vtlDeviceType: Optional[VTLDeviceType]
    def vtlDeviceVendor: Optional[VTLDeviceVendor]
    def vtlDeviceProductIdentifier: Optional[VTLDeviceProductIdentifier]
    def deviceiSCSIAttributes
        : Optional[zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly]
    def getVtlDeviceARN: ZIO[Any, AwsError, VTLDeviceARN] =
      AwsError.unwrapOptionField("vtlDeviceARN", vtlDeviceARN)
    def getVtlDeviceType: ZIO[Any, AwsError, VTLDeviceType] =
      AwsError.unwrapOptionField("vtlDeviceType", vtlDeviceType)
    def getVtlDeviceVendor: ZIO[Any, AwsError, VTLDeviceVendor] =
      AwsError.unwrapOptionField("vtlDeviceVendor", vtlDeviceVendor)
    def getVtlDeviceProductIdentifier
        : ZIO[Any, AwsError, VTLDeviceProductIdentifier] =
      AwsError.unwrapOptionField(
        "vtlDeviceProductIdentifier",
        vtlDeviceProductIdentifier
      )
    def getDeviceiSCSIAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("deviceiSCSIAttributes", deviceiSCSIAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ) extends zio.aws.storagegateway.model.VTLDevice.ReadOnly {
    override val vtlDeviceARN: Optional[VTLDeviceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.vtlDeviceARN())
      .map(value => zio.aws.storagegateway.model.primitives.VTLDeviceARN(value))
    override val vtlDeviceType: Optional[VTLDeviceType] = zio.aws.core.internal
      .optionalFromNullable(impl.vtlDeviceType())
      .map(value =>
        zio.aws.storagegateway.model.primitives.VTLDeviceType(value)
      )
    override val vtlDeviceVendor: Optional[VTLDeviceVendor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vtlDeviceVendor())
        .map(value =>
          zio.aws.storagegateway.model.primitives.VTLDeviceVendor(value)
        )
    override val vtlDeviceProductIdentifier
        : Optional[VTLDeviceProductIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.vtlDeviceProductIdentifier())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .VTLDeviceProductIdentifier(value)
      )
    override val deviceiSCSIAttributes: Optional[
      zio.aws.storagegateway.model.DeviceiSCSIAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceiSCSIAttributes())
      .map(value =>
        zio.aws.storagegateway.model.DeviceiSCSIAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VTLDevice
  ): zio.aws.storagegateway.model.VTLDevice.ReadOnly = new Wrapper(impl)
}
