package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters._
sealed trait GatewayCapacity {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.GatewayCapacity
}
object GatewayCapacity {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.GatewayCapacity
  ): zio.aws.storagegateway.model.GatewayCapacity = value match {
    case software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.SMALL =>
      val r = Small
      r
    case software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.LARGE =>
      val r = Large
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.GatewayCapacity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.GatewayCapacity =
      software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.UNKNOWN_TO_SDK_VERSION
  }
  case object Small extends zio.aws.storagegateway.model.GatewayCapacity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.GatewayCapacity =
      software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.SMALL
  }
  case object Medium extends zio.aws.storagegateway.model.GatewayCapacity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.GatewayCapacity =
      software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.MEDIUM
  }
  case object Large extends zio.aws.storagegateway.model.GatewayCapacity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.GatewayCapacity =
      software.amazon.awssdk.services.storagegateway.model.GatewayCapacity.LARGE
  }
}
