package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTapesResponse(
    tapeARNs: Optional[Iterable[TapeARN]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse = {
    import CreateTapesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse
      .builder()
      .optionallyWith(
        tapeARNs.map(value =>
          value.map { item =>
            TapeARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tapeARNs)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateTapesResponse.wrap(buildAwsValue())
}
object CreateTapesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateTapesResponse =
      zio.aws.storagegateway.model
        .CreateTapesResponse(tapeARNs.map(value => value))
    def tapeARNs: Optional[List[TapeARN]]
    def getTapeARNs: ZIO[Any, AwsError, List[TapeARN]] =
      AwsError.unwrapOptionField("tapeARNs", tapeARNs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse
  ) extends zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly {
    override val tapeARNs: Optional[List[TapeARN]] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.TapeARN(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse
  ): zio.aws.storagegateway.model.CreateTapesResponse.ReadOnly = new Wrapper(
    impl
  )
}
