package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileShareRequest(
    fileShareARN: FileShareARN,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest = {
    import DeleteFileShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest
      .builder()
      .fileShareARN(FileShareARN.unwrap(fileShareARN): java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteFileShareRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteFileShareRequest.wrap(buildAwsValue())
}
object DeleteFileShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteFileShareRequest =
      zio.aws.storagegateway.model
        .DeleteFileShareRequest(fileShareARN, forceDelete.map(value => value))
    def fileShareARN: FileShareARN
    def forceDelete: Optional[Boolean]
    def getFileShareARN: ZIO[Any, Nothing, FileShareARN] =
      ZIO.succeed(fileShareARN)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest
  ) extends zio.aws.storagegateway.model.DeleteFileShareRequest.ReadOnly {
    override val fileShareARN: FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN(impl.fileShareARN())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest
  ): zio.aws.storagegateway.model.DeleteFileShareRequest.ReadOnly = new Wrapper(
    impl
  )
}
