package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileShareARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateNfsFileShareResponse(
    fileShareARN: Optional[FileShareARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse = {
    import UpdateNfsFileShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateNfsFileShareResponse
      .wrap(buildAwsValue())
}
object UpdateNfsFileShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateNfsFileShareResponse =
      zio.aws.storagegateway.model
        .UpdateNfsFileShareResponse(fileShareARN.map(value => value))
    def fileShareARN: Optional[FileShareARN]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse
  ) extends zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse
  ): zio.aws.storagegateway.model.UpdateNfsFileShareResponse.ReadOnly =
    new Wrapper(impl)
}
