package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TargetARN, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStorediScsiVolumeResponse(
    volumeARN: Optional[VolumeARN] = Optional.Absent,
    volumeSizeInBytes: Optional[Long] = Optional.Absent,
    targetARN: Optional[TargetARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse = {
    import CreateStorediScsiVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse
      .wrap(buildAwsValue())
}
object CreateStorediScsiVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse =
      zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse(
        volumeARN.map(value => value),
        volumeSizeInBytes.map(value => value),
        targetARN.map(value => value)
      )
    def volumeARN: Optional[VolumeARN]
    def volumeSizeInBytes: Optional[Long]
    def targetARN: Optional[TargetARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse
  ) extends zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInBytes())
      .map(value => value: Long)
    override val targetARN: Optional[TargetARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse
  ): zio.aws.storagegateway.model.CreateStorediScsiVolumeResponse.ReadOnly =
    new Wrapper(impl)
}
