package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableGatewayRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest = {
    import DisableGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DisableGatewayRequest.ReadOnly =
    zio.aws.storagegateway.model.DisableGatewayRequest.wrap(buildAwsValue())
}
object DisableGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DisableGatewayRequest =
      zio.aws.storagegateway.model.DisableGatewayRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest
  ) extends zio.aws.storagegateway.model.DisableGatewayRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest
  ): zio.aws.storagegateway.model.DisableGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
