package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  VTLDeviceARN,
  GatewayARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVtlDevicesRequest(
    gatewayARN: GatewayARN,
    vtlDeviceARNs: Optional[Iterable[VTLDeviceARN]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest = {
    import DescribeVtlDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        vtlDeviceARNs.map(value =>
          value.map { item =>
            VTLDeviceARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vtlDeviceARNs)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeVtlDevicesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeVtlDevicesRequest.wrap(buildAwsValue())
}
object DescribeVtlDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeVtlDevicesRequest =
      zio.aws.storagegateway.model.DescribeVtlDevicesRequest(
        gatewayARN,
        vtlDeviceARNs.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def gatewayARN: GatewayARN
    def vtlDeviceARNs: Optional[List[VTLDeviceARN]]
    def marker: Optional[Marker]
    def limit: Optional[PositiveIntObject]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getVtlDeviceARNs: ZIO[Any, AwsError, List[VTLDeviceARN]] =
      AwsError.unwrapOptionField("vtlDeviceARNs", vtlDeviceARNs)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest
  ) extends zio.aws.storagegateway.model.DescribeVtlDevicesRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val vtlDeviceARNs: Optional[List[VTLDeviceARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vtlDeviceARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.VTLDeviceARN(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest
  ): zio.aws.storagegateway.model.DescribeVtlDevicesRequest.ReadOnly =
    new Wrapper(impl)
}
