package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFileSharesResponse(
    marker: Optional[Marker] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent,
    fileShareInfoList: Optional[
      Iterable[zio.aws.storagegateway.model.FileShareInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse = {
    import ListFileSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        fileShareInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileShareInfoList)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly =
    zio.aws.storagegateway.model.ListFileSharesResponse.wrap(buildAwsValue())
}
object ListFileSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListFileSharesResponse =
      zio.aws.storagegateway.model.ListFileSharesResponse(
        marker.map(value => value),
        nextMarker.map(value => value),
        fileShareInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[Marker]
    def nextMarker: Optional[Marker]
    def fileShareInfoList
        : Optional[List[zio.aws.storagegateway.model.FileShareInfo.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getFileShareInfoList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.FileShareInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("fileShareInfoList", fileShareInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ) extends zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val fileShareInfoList
        : Optional[List[zio.aws.storagegateway.model.FileShareInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileShareInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.FileShareInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse
  ): zio.aws.storagegateway.model.ListFileSharesResponse.ReadOnly = new Wrapper(
    impl
  )
}
