package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{BandwidthType, GatewayARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBandwidthRateLimitRequest(
    gatewayARN: GatewayARN,
    bandwidthType: BandwidthType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest = {
    import DeleteBandwidthRateLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .bandwidthType(BandwidthType.unwrap(bandwidthType): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest
      .wrap(buildAwsValue())
}
object DeleteBandwidthRateLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest =
      zio.aws.storagegateway.model
        .DeleteBandwidthRateLimitRequest(gatewayARN, bandwidthType)
    def gatewayARN: GatewayARN
    def bandwidthType: BandwidthType
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getBandwidthType: ZIO[Any, Nothing, BandwidthType] =
      ZIO.succeed(bandwidthType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest
  ) extends zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val bandwidthType: BandwidthType =
      zio.aws.storagegateway.model.primitives
        .BandwidthType(impl.bandwidthType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest
  ): zio.aws.storagegateway.model.DeleteBandwidthRateLimitRequest.ReadOnly =
    new Wrapper(impl)
}
