package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemAssociationsRequest(
    fileSystemAssociationARNList: Iterable[FileSystemAssociationARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest = {
    import DescribeFileSystemAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest
      .builder()
      .fileSystemAssociationARNList(fileSystemAssociationARNList.map { item =>
        FileSystemAssociationARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeFileSystemAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest =
      zio.aws.storagegateway.model
        .DescribeFileSystemAssociationsRequest(fileSystemAssociationARNList)
    def fileSystemAssociationARNList: List[FileSystemAssociationARN]
    def getFileSystemAssociationARNList
        : ZIO[Any, Nothing, List[FileSystemAssociationARN]] =
      ZIO.succeed(fileSystemAssociationARNList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest
  ) extends zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest.ReadOnly {
    override val fileSystemAssociationARNList: List[FileSystemAssociationARN] =
      impl
        .fileSystemAssociationARNList()
        .asScala
        .map { item =>
          zio.aws.storagegateway.model.primitives.FileSystemAssociationARN(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest
  ): zio.aws.storagegateway.model.DescribeFileSystemAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
