package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  FileShareId,
  FileShareARN,
  DNSHostName,
  Squash,
  RegionId,
  FileShareStatus,
  GatewayARN,
  IPV4AddressCIDR,
  LocationARN,
  Path,
  NotificationPolicy,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NFSFileShareInfo(
    nfsFileShareDefaults: Optional[
      zio.aws.storagegateway.model.NFSFileShareDefaults
    ] = Optional.Absent,
    fileShareARN: Optional[FileShareARN] = Optional.Absent,
    fileShareId: Optional[FileShareId] = Optional.Absent,
    fileShareStatus: Optional[FileShareStatus] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    path: Optional[Path] = Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    locationARN: Optional[LocationARN] = Optional.Absent,
    defaultStorageClass: Optional[StorageClass] = Optional.Absent,
    objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      Optional.Absent,
    clientList: Optional[Iterable[IPV4AddressCIDR]] = Optional.Absent,
    squash: Optional[Squash] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    guessMIMETypeEnabled: Optional[Boolean] = Optional.Absent,
    requesterPays: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] =
      Optional.Absent,
    fileShareName: Optional[FileShareName] = Optional.Absent,
    cacheAttributes: Optional[zio.aws.storagegateway.model.CacheAttributes] =
      Optional.Absent,
    notificationPolicy: Optional[NotificationPolicy] = Optional.Absent,
    vpcEndpointDNSName: Optional[DNSHostName] = Optional.Absent,
    bucketRegion: Optional[RegionId] = Optional.Absent,
    auditDestinationARN: Optional[AuditDestinationARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo = {
    import NFSFileShareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo
      .builder()
      .optionallyWith(nfsFileShareDefaults.map(value => value.buildAwsValue()))(
        _.nfsFileShareDefaults
      )
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        fileShareId.map(value => FileShareId.unwrap(value): java.lang.String)
      )(_.fileShareId)
      .optionallyWith(
        fileShareStatus.map(value =>
          FileShareStatus.unwrap(value): java.lang.String
        )
      )(_.fileShareStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        locationARN.map(value => LocationARN.unwrap(value): java.lang.String)
      )(_.locationARN)
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(
        clientList.map(value =>
          value.map { item =>
            IPV4AddressCIDR.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientList)
      .optionallyWith(
        squash.map(value => Squash.unwrap(value): java.lang.String)
      )(_.squash)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(
        vpcEndpointDNSName.map(value =>
          DNSHostName.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointDNSName)
      .optionallyWith(
        bucketRegion.map(value => RegionId.unwrap(value): java.lang.String)
      )(_.bucketRegion)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly =
    zio.aws.storagegateway.model.NFSFileShareInfo.wrap(buildAwsValue())
}
object NFSFileShareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NFSFileShareInfo =
      zio.aws.storagegateway.model.NFSFileShareInfo(
        nfsFileShareDefaults.map(value => value.asEditable),
        fileShareARN.map(value => value),
        fileShareId.map(value => value),
        fileShareStatus.map(value => value),
        gatewayARN.map(value => value),
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        path.map(value => value),
        role.map(value => value),
        locationARN.map(value => value),
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        clientList.map(value => value),
        squash.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        vpcEndpointDNSName.map(value => value),
        bucketRegion.map(value => value),
        auditDestinationARN.map(value => value)
      )
    def nfsFileShareDefaults
        : Optional[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly]
    def fileShareARN: Optional[FileShareARN]
    def fileShareId: Optional[FileShareId]
    def fileShareStatus: Optional[FileShareStatus]
    def gatewayARN: Optional[GatewayARN]
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def path: Optional[Path]
    def role: Optional[Role]
    def locationARN: Optional[LocationARN]
    def defaultStorageClass: Optional[StorageClass]
    def objectACL: Optional[zio.aws.storagegateway.model.ObjectACL]
    def clientList: Optional[List[IPV4AddressCIDR]]
    def squash: Optional[Squash]
    def readOnly: Optional[Boolean]
    def guessMIMETypeEnabled: Optional[Boolean]
    def requesterPays: Optional[Boolean]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def fileShareName: Optional[FileShareName]
    def cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Optional[NotificationPolicy]
    def vpcEndpointDNSName: Optional[DNSHostName]
    def bucketRegion: Optional[RegionId]
    def auditDestinationARN: Optional[AuditDestinationARN]
    def getNfsFileShareDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("nfsFileShareDefaults", nfsFileShareDefaults)
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getFileShareId: ZIO[Any, AwsError, FileShareId] =
      AwsError.unwrapOptionField("fileShareId", fileShareId)
    def getFileShareStatus: ZIO[Any, AwsError, FileShareStatus] =
      AwsError.unwrapOptionField("fileShareStatus", fileShareStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getLocationARN: ZIO[Any, AwsError, LocationARN] =
      AwsError.unwrapOptionField("locationARN", locationARN)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getClientList: ZIO[Any, AwsError, List[IPV4AddressCIDR]] =
      AwsError.unwrapOptionField("clientList", clientList)
    def getSquash: ZIO[Any, AwsError, Squash] =
      AwsError.unwrapOptionField("squash", squash)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getVpcEndpointDNSName: ZIO[Any, AwsError, DNSHostName] =
      AwsError.unwrapOptionField("vpcEndpointDNSName", vpcEndpointDNSName)
    def getBucketRegion: ZIO[Any, AwsError, RegionId] =
      AwsError.unwrapOptionField("bucketRegion", bucketRegion)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo
  ) extends zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly {
    override val nfsFileShareDefaults
        : Optional[zio.aws.storagegateway.model.NFSFileShareDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsFileShareDefaults())
        .map(value =>
          zio.aws.storagegateway.model.NFSFileShareDefaults.wrap(value)
        )
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val fileShareId: Optional[FileShareId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareId())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareId(value))
    override val fileShareStatus: Optional[FileShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileShareStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.FileShareStatus(value)
        )
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.storagegateway.model.primitives.Path(value))
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.storagegateway.model.primitives.Role(value))
    override val locationARN: Optional[LocationARN] = zio.aws.core.internal
      .optionalFromNullable(impl.locationARN())
      .map(value => zio.aws.storagegateway.model.primitives.LocationARN(value))
    override val defaultStorageClass: Optional[StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultStorageClass())
        .map(value =>
          zio.aws.storagegateway.model.primitives.StorageClass(value)
        )
    override val objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val clientList: Optional[List[IPV4AddressCIDR]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.IPV4AddressCIDR(item)
          }.toList
        )
    override val squash: Optional[Squash] = zio.aws.core.internal
      .optionalFromNullable(impl.squash())
      .map(value => zio.aws.storagegateway.model.primitives.Squash(value))
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val guessMIMETypeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.guessMIMETypeEnabled())
      .map(value => value: Boolean)
    override val requesterPays: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterPays())
      .map(value => value: Boolean)
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val fileShareName: Optional[FileShareName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheAttributes())
        .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Optional[NotificationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationPolicy())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
        )
    override val vpcEndpointDNSName: Optional[DNSHostName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointDNSName())
        .map(value =>
          zio.aws.storagegateway.model.primitives.DNSHostName(value)
        )
    override val bucketRegion: Optional[RegionId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketRegion())
      .map(value => zio.aws.storagegateway.model.primitives.RegionId(value))
    override val auditDestinationARN: Optional[AuditDestinationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditDestinationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo
  ): zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly = new Wrapper(impl)
}
