package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotScheduleResponse(
    volumeARN: Optional[VolumeARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse = {
    import UpdateSnapshotScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse
      .wrap(buildAwsValue())
}
object UpdateSnapshotScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse =
      zio.aws.storagegateway.model
        .UpdateSnapshotScheduleResponse(volumeARN.map(value => value))
    def volumeARN: Optional[VolumeARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse
  ) extends zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse
  ): zio.aws.storagegateway.model.UpdateSnapshotScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
