package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Marker, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTapeRecoveryPointsResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    tapeRecoveryPointInfos: Optional[
      Iterable[zio.aws.storagegateway.model.TapeRecoveryPointInfo]
    ] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse = {
    import DescribeTapeRecoveryPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        tapeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tapeRecoveryPointInfos)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse
      .wrap(buildAwsValue())
}
object DescribeTapeRecoveryPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse =
      zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse(
        gatewayARN.map(value => value),
        tapeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def tapeRecoveryPointInfos: Optional[
      List[zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly]
    ]
    def marker: Optional[Marker]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getTapeRecoveryPointInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tapeRecoveryPointInfos",
      tapeRecoveryPointInfos
    )
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ) extends zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val tapeRecoveryPointInfos: Optional[
      List[zio.aws.storagegateway.model.TapeRecoveryPointInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeRecoveryPointInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.TapeRecoveryPointInfo.wrap(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
  ): zio.aws.storagegateway.model.DescribeTapeRecoveryPointsResponse.ReadOnly =
    new Wrapper(impl)
}
