package zio.aws.storagegateway.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  DoubleObject,
  KMSKey,
  VolumeARN,
  DiskId,
  VolumeStatus,
  VolumeId,
  SnapshotId,
  VolumeUsedInBytes,
  CreatedDate,
  TargetName,
  VolumeAttachmentStatus,
  VolumeType
}
import scala.jdk.CollectionConverters._
final case class StorediSCSIVolume(
    volumeARN: Optional[VolumeARN] = Optional.Absent,
    volumeId: Optional[VolumeId] = Optional.Absent,
    volumeType: Optional[VolumeType] = Optional.Absent,
    volumeStatus: Optional[VolumeStatus] = Optional.Absent,
    volumeAttachmentStatus: Optional[VolumeAttachmentStatus] = Optional.Absent,
    volumeSizeInBytes: Optional[Long] = Optional.Absent,
    volumeProgress: Optional[DoubleObject] = Optional.Absent,
    volumeDiskId: Optional[DiskId] = Optional.Absent,
    sourceSnapshotId: Optional[SnapshotId] = Optional.Absent,
    preservedExistingData: Optional[Boolean] = Optional.Absent,
    volumeiSCSIAttributes: Optional[
      zio.aws.storagegateway.model.VolumeiSCSIAttributes
    ] = Optional.Absent,
    createdDate: Optional[CreatedDate] = Optional.Absent,
    volumeUsedInBytes: Optional[VolumeUsedInBytes] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    targetName: Optional[TargetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume = {
    import StorediSCSIVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(
        volumeStatus.map(value => VolumeStatus.unwrap(value): java.lang.String)
      )(_.volumeStatus)
      .optionallyWith(
        volumeAttachmentStatus.map(value =>
          VolumeAttachmentStatus.unwrap(value): java.lang.String
        )
      )(_.volumeAttachmentStatus)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(volumeProgress.map(value => value: java.lang.Double))(
        _.volumeProgress
      )
      .optionallyWith(
        volumeDiskId.map(value => DiskId.unwrap(value): java.lang.String)
      )(_.volumeDiskId)
      .optionallyWith(
        sourceSnapshotId.map(value =>
          SnapshotId.unwrap(value): java.lang.String
        )
      )(_.sourceSnapshotId)
      .optionallyWith(
        preservedExistingData.map(value => value: java.lang.Boolean)
      )(_.preservedExistingData)
      .optionallyWith(
        volumeiSCSIAttributes.map(value => value.buildAwsValue())
      )(_.volumeiSCSIAttributes)
      .optionallyWith(
        createdDate.map(value => CreatedDate.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        volumeUsedInBytes.map(value =>
          VolumeUsedInBytes.unwrap(value): java.lang.Long
        )
      )(_.volumeUsedInBytes)
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        targetName.map(value => TargetName.unwrap(value): java.lang.String)
      )(_.targetName)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly =
    zio.aws.storagegateway.model.StorediSCSIVolume.wrap(buildAwsValue())
}
object StorediSCSIVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.StorediSCSIVolume =
      zio.aws.storagegateway.model.StorediSCSIVolume(
        volumeARN.map(value => value),
        volumeId.map(value => value),
        volumeType.map(value => value),
        volumeStatus.map(value => value),
        volumeAttachmentStatus.map(value => value),
        volumeSizeInBytes.map(value => value),
        volumeProgress.map(value => value),
        volumeDiskId.map(value => value),
        sourceSnapshotId.map(value => value),
        preservedExistingData.map(value => value),
        volumeiSCSIAttributes.map(value => value.asEditable),
        createdDate.map(value => value),
        volumeUsedInBytes.map(value => value),
        kmsKey.map(value => value),
        targetName.map(value => value)
      )
    def volumeARN: Optional[VolumeARN]
    def volumeId: Optional[VolumeId]
    def volumeType: Optional[VolumeType]
    def volumeStatus: Optional[VolumeStatus]
    def volumeAttachmentStatus: Optional[VolumeAttachmentStatus]
    def volumeSizeInBytes: Optional[Long]
    def volumeProgress: Optional[DoubleObject]
    def volumeDiskId: Optional[DiskId]
    def sourceSnapshotId: Optional[SnapshotId]
    def preservedExistingData: Optional[Boolean]
    def volumeiSCSIAttributes
        : Optional[zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly]
    def createdDate: Optional[CreatedDate]
    def volumeUsedInBytes: Optional[VolumeUsedInBytes]
    def kmsKey: Optional[KMSKey]
    def targetName: Optional[TargetName]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeStatus: ZIO[Any, AwsError, VolumeStatus] =
      AwsError.unwrapOptionField("volumeStatus", volumeStatus)
    def getVolumeAttachmentStatus: ZIO[Any, AwsError, VolumeAttachmentStatus] =
      AwsError.unwrapOptionField(
        "volumeAttachmentStatus",
        volumeAttachmentStatus
      )
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getVolumeProgress: ZIO[Any, AwsError, DoubleObject] =
      AwsError.unwrapOptionField("volumeProgress", volumeProgress)
    def getVolumeDiskId: ZIO[Any, AwsError, DiskId] =
      AwsError.unwrapOptionField("volumeDiskId", volumeDiskId)
    def getSourceSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("sourceSnapshotId", sourceSnapshotId)
    def getPreservedExistingData: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preservedExistingData", preservedExistingData)
    def getVolumeiSCSIAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("volumeiSCSIAttributes", volumeiSCSIAttributes)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDate] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVolumeUsedInBytes: ZIO[Any, AwsError, VolumeUsedInBytes] =
      AwsError.unwrapOptionField("volumeUsedInBytes", volumeUsedInBytes)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getTargetName: ZIO[Any, AwsError, TargetName] =
      AwsError.unwrapOptionField("targetName", targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ) extends zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeId(value))
    override val volumeType: Optional[VolumeType] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeType())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeType(value))
    override val volumeStatus: Optional[VolumeStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeStatus())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeStatus(value))
    override val volumeAttachmentStatus: Optional[VolumeAttachmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeAttachmentStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.VolumeAttachmentStatus(value)
        )
    override val volumeSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInBytes())
      .map(value => value: Long)
    override val volumeProgress: Optional[DoubleObject] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeProgress())
      .map(value => value: DoubleObject)
    override val volumeDiskId: Optional[DiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeDiskId())
      .map(value => zio.aws.storagegateway.model.primitives.DiskId(value))
    override val sourceSnapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSnapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
    override val preservedExistingData: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preservedExistingData())
        .map(value => value: Boolean)
    override val volumeiSCSIAttributes: Optional[
      zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeiSCSIAttributes())
      .map(value =>
        zio.aws.storagegateway.model.VolumeiSCSIAttributes.wrap(value)
      )
    override val createdDate: Optional[CreatedDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.storagegateway.model.primitives.CreatedDate(value))
    override val volumeUsedInBytes: Optional[VolumeUsedInBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeUsedInBytes())
        .map(value =>
          zio.aws.storagegateway.model.primitives.VolumeUsedInBytes(value)
        )
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val targetName: Optional[TargetName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetName())
      .map(value => zio.aws.storagegateway.model.primitives.TargetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume
  ): zio.aws.storagegateway.model.StorediSCSIVolume.ReadOnly = new Wrapper(impl)
}
