package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  PoolId,
  Time,
  TapeSize,
  TapeARN,
  TapeBarcode,
  GatewayARN,
  TapeStatus
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TapeInfo(
    tapeARN: Option[TapeARN] = None,
    tapeBarcode: Option[TapeBarcode] = None,
    tapeSizeInBytes: Option[TapeSize] = None,
    tapeStatus: Option[TapeStatus] = None,
    gatewayARN: Option[GatewayARN] = None,
    poolId: Option[PoolId] = None,
    retentionStartDate: Option[Time] = None,
    poolEntryDate: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeInfo = {
    import TapeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeInfo
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeBarcode.map(value => TapeBarcode.unwrap(value): java.lang.String)
      )(_.tapeBarcode)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(
        tapeStatus.map(value => TapeStatus.unwrap(value): java.lang.String)
      )(_.tapeStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        poolId.map(value => PoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        retentionStartDate.map(value => Time.unwrap(value): Instant)
      )(_.retentionStartDate)
      .optionallyWith(poolEntryDate.map(value => Time.unwrap(value): Instant))(
        _.poolEntryDate
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeInfo.ReadOnly =
    zio.aws.storagegateway.model.TapeInfo.wrap(buildAwsValue())
}
object TapeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeInfo =
      zio.aws.storagegateway.model.TapeInfo(
        tapeARN.map(value => value),
        tapeBarcode.map(value => value),
        tapeSizeInBytes.map(value => value),
        tapeStatus.map(value => value),
        gatewayARN.map(value => value),
        poolId.map(value => value),
        retentionStartDate.map(value => value),
        poolEntryDate.map(value => value)
      )
    def tapeARN: Option[TapeARN]
    def tapeBarcode: Option[TapeBarcode]
    def tapeSizeInBytes: Option[TapeSize]
    def tapeStatus: Option[TapeStatus]
    def gatewayARN: Option[GatewayARN]
    def poolId: Option[PoolId]
    def retentionStartDate: Option[Time]
    def poolEntryDate: Option[Time]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeBarcode: ZIO[Any, AwsError, TapeBarcode] =
      AwsError.unwrapOptionField("tapeBarcode", tapeBarcode)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getTapeStatus: ZIO[Any, AwsError, TapeStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getPoolId: ZIO[Any, AwsError, PoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getRetentionStartDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("retentionStartDate", retentionStartDate)
    def getPoolEntryDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("poolEntryDate", poolEntryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ) extends zio.aws.storagegateway.model.TapeInfo.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeBarcode: Option[TapeBarcode] = scala
      .Option(impl.tapeBarcode())
      .map(value => zio.aws.storagegateway.model.primitives.TapeBarcode(value))
    override val tapeSizeInBytes: Option[TapeSize] = scala
      .Option(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val tapeStatus: Option[TapeStatus] = scala
      .Option(impl.tapeStatus())
      .map(value => zio.aws.storagegateway.model.primitives.TapeStatus(value))
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val poolId: Option[PoolId] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.storagegateway.model.primitives.PoolId(value))
    override val retentionStartDate: Option[Time] = scala
      .Option(impl.retentionStartDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val poolEntryDate: Option[Time] = scala
      .Option(impl.poolEntryDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ): zio.aws.storagegateway.model.TapeInfo.ReadOnly = new Wrapper(impl)
}
