package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsToResourceRequest(
    resourceARN: ResourceARN,
    tags: Iterable[zio.aws.storagegateway.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AddTagsToResourceRequest.ReadOnly =
    zio.aws.storagegateway.model.AddTagsToResourceRequest.wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddTagsToResourceRequest =
      zio.aws.storagegateway.model.AddTagsToResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ResourceARN
    def tags: List[zio.aws.storagegateway.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest
  ) extends zio.aws.storagegateway.model.AddTagsToResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.storagegateway.model.primitives.ResourceARN(impl.resourceARN())
    override val tags: List[zio.aws.storagegateway.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest
  ): zio.aws.storagegateway.model.AddTagsToResourceRequest.ReadOnly =
    new Wrapper(impl)
}
