package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TargetARN, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCachediScsiVolumeResponse(
    volumeARN: Option[VolumeARN] = None,
    targetARN: Option[TargetARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse = {
    import CreateCachediScsiVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse
      .wrap(buildAwsValue())
}
object CreateCachediScsiVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse =
      zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse(
        volumeARN.map(value => value),
        targetARN.map(value => value)
      )
    def volumeARN: Option[VolumeARN]
    def targetARN: Option[TargetARN]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse
  ) extends zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly {
    override val volumeARN: Option[VolumeARN] = scala
      .Option(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val targetARN: Option[TargetARN] = scala
      .Option(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse
  ): zio.aws.storagegateway.model.CreateCachediScsiVolumeResponse.ReadOnly =
    new Wrapper(impl)
}
