package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNfsFileSharesResponse(
    nfsFileShareInfoList: Option[
      Iterable[zio.aws.storagegateway.model.NFSFileShareInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse = {
    import DescribeNfsFileSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse
      .builder()
      .optionallyWith(
        nfsFileShareInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsFileShareInfoList)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeNfsFileSharesResponse
      .wrap(buildAwsValue())
}
object DescribeNfsFileSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeNfsFileSharesResponse =
      zio.aws.storagegateway.model.DescribeNfsFileSharesResponse(
        nfsFileShareInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nfsFileShareInfoList
        : Option[List[zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly]]
    def getNfsFileShareInfoList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("nfsFileShareInfoList", nfsFileShareInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse
  ) extends zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly {
    override val nfsFileShareInfoList
        : Option[List[zio.aws.storagegateway.model.NFSFileShareInfo.ReadOnly]] =
      scala
        .Option(impl.nfsFileShareInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.NFSFileShareInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse
  ): zio.aws.storagegateway.model.DescribeNfsFileSharesResponse.ReadOnly =
    new Wrapper(impl)
}
