package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationSyncErrorCode
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FileSystemAssociationStatusDetail(
    errorCode: Option[FileSystemAssociationSyncErrorCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationStatusDetail = {
    import FileSystemAssociationStatusDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationStatusDetail
      .builder()
      .optionallyWith(
        errorCode.map(value =>
          FileSystemAssociationSyncErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly =
    zio.aws.storagegateway.model.FileSystemAssociationStatusDetail
      .wrap(buildAwsValue())
}
object FileSystemAssociationStatusDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationStatusDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.FileSystemAssociationStatusDetail =
      zio.aws.storagegateway.model
        .FileSystemAssociationStatusDetail(errorCode.map(value => value))
    def errorCode: Option[FileSystemAssociationSyncErrorCode]
    def getErrorCode: ZIO[Any, AwsError, FileSystemAssociationSyncErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationStatusDetail
  ) extends zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly {
    override val errorCode: Option[FileSystemAssociationSyncErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .FileSystemAssociationSyncErrorCode(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationStatusDetail
  ): zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly =
    new Wrapper(impl)
}
