package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartAvailabilityMonitorTestResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse = {
    import StartAvailabilityMonitorTestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly =
    zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse
      .wrap(buildAwsValue())
}
object StartAvailabilityMonitorTestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse =
      zio.aws.storagegateway.model
        .StartAvailabilityMonitorTestResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse
  ) extends zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse
  ): zio.aws.storagegateway.model.StartAvailabilityMonitorTestResponse.ReadOnly =
    new Wrapper(impl)
}
