package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{IqnName, TargetARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteChapCredentialsRequest(
    targetARN: TargetARN,
    initiatorName: IqnName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest = {
    import DeleteChapCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest
      .builder()
      .targetARN(TargetARN.unwrap(targetARN): java.lang.String)
      .initiatorName(IqnName.unwrap(initiatorName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteChapCredentialsRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteChapCredentialsRequest
      .wrap(buildAwsValue())
}
object DeleteChapCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteChapCredentialsRequest =
      zio.aws.storagegateway.model
        .DeleteChapCredentialsRequest(targetARN, initiatorName)
    def targetARN: TargetARN
    def initiatorName: IqnName
    def getTargetARN: ZIO[Any, Nothing, TargetARN] = ZIO.succeed(targetARN)
    def getInitiatorName: ZIO[Any, Nothing, IqnName] =
      ZIO.succeed(initiatorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest
  ) extends zio.aws.storagegateway.model.DeleteChapCredentialsRequest.ReadOnly {
    override val targetARN: TargetARN =
      zio.aws.storagegateway.model.primitives.TargetARN(impl.targetARN())
    override val initiatorName: IqnName =
      zio.aws.storagegateway.model.primitives.IqnName(impl.initiatorName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest
  ): zio.aws.storagegateway.model.DeleteChapCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
