package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  DiskAttribute,
  DiskAllocationType,
  DiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Disk(
    diskId: Option[DiskId] = None,
    diskPath: Option[String] = None,
    diskNode: Option[String] = None,
    diskStatus: Option[String] = None,
    diskSizeInBytes: Option[Long] = None,
    diskAllocationType: Option[DiskAllocationType] = None,
    diskAllocationResource: Option[String] = None,
    diskAttributeList: Option[Iterable[DiskAttribute]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.Disk
      .builder()
      .optionallyWith(
        diskId.map(value => DiskId.unwrap(value): java.lang.String)
      )(_.diskId)
      .optionallyWith(diskPath.map(value => value: java.lang.String))(
        _.diskPath
      )
      .optionallyWith(diskNode.map(value => value: java.lang.String))(
        _.diskNode
      )
      .optionallyWith(diskStatus.map(value => value: java.lang.String))(
        _.diskStatus
      )
      .optionallyWith(diskSizeInBytes.map(value => value: java.lang.Long))(
        _.diskSizeInBytes
      )
      .optionallyWith(
        diskAllocationType.map(value =>
          DiskAllocationType.unwrap(value): java.lang.String
        )
      )(_.diskAllocationType)
      .optionallyWith(
        diskAllocationResource.map(value => value: java.lang.String)
      )(_.diskAllocationResource)
      .optionallyWith(
        diskAttributeList.map(value =>
          value.map { item =>
            DiskAttribute.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.diskAttributeList)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.Disk.ReadOnly =
    zio.aws.storagegateway.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.Disk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.Disk =
      zio.aws.storagegateway.model.Disk(
        diskId.map(value => value),
        diskPath.map(value => value),
        diskNode.map(value => value),
        diskStatus.map(value => value),
        diskSizeInBytes.map(value => value),
        diskAllocationType.map(value => value),
        diskAllocationResource.map(value => value),
        diskAttributeList.map(value => value)
      )
    def diskId: Option[DiskId]
    def diskPath: Option[String]
    def diskNode: Option[String]
    def diskStatus: Option[String]
    def diskSizeInBytes: Option[Long]
    def diskAllocationType: Option[DiskAllocationType]
    def diskAllocationResource: Option[String]
    def diskAttributeList: Option[List[DiskAttribute]]
    def getDiskId: ZIO[Any, AwsError, DiskId] =
      AwsError.unwrapOptionField("diskId", diskId)
    def getDiskPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskPath", diskPath)
    def getDiskNode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskNode", diskNode)
    def getDiskStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskStatus", diskStatus)
    def getDiskSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("diskSizeInBytes", diskSizeInBytes)
    def getDiskAllocationType: ZIO[Any, AwsError, DiskAllocationType] =
      AwsError.unwrapOptionField("diskAllocationType", diskAllocationType)
    def getDiskAllocationResource: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("diskAllocationResource", diskAllocationResource)
    def getDiskAttributeList: ZIO[Any, AwsError, List[DiskAttribute]] =
      AwsError.unwrapOptionField("diskAttributeList", diskAttributeList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.Disk
  ) extends zio.aws.storagegateway.model.Disk.ReadOnly {
    override val diskId: Option[DiskId] = scala
      .Option(impl.diskId())
      .map(value => zio.aws.storagegateway.model.primitives.DiskId(value))
    override val diskPath: Option[String] =
      scala.Option(impl.diskPath()).map(value => value: String)
    override val diskNode: Option[String] =
      scala.Option(impl.diskNode()).map(value => value: String)
    override val diskStatus: Option[String] =
      scala.Option(impl.diskStatus()).map(value => value: String)
    override val diskSizeInBytes: Option[Long] =
      scala.Option(impl.diskSizeInBytes()).map(value => value: Long)
    override val diskAllocationType: Option[DiskAllocationType] = scala
      .Option(impl.diskAllocationType())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DiskAllocationType(value)
      )
    override val diskAllocationResource: Option[String] =
      scala.Option(impl.diskAllocationResource()).map(value => value: String)
    override val diskAttributeList: Option[List[DiskAttribute]] = scala
      .Option(impl.diskAttributeList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.DiskAttribute(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.Disk
  ): zio.aws.storagegateway.model.Disk.ReadOnly = new Wrapper(impl)
}
