package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemAssociationResponse(
    fileSystemAssociationARN: Option[FileSystemAssociationARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse = {
    import UpdateFileSystemAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
      .builder()
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateFileSystemAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse =
      zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse(
        fileSystemAssociationARN.map(value => value)
      )
    def fileSystemAssociationARN: Option[FileSystemAssociationARN]
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ) extends zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly {
    override val fileSystemAssociationARN: Option[FileSystemAssociationARN] =
      scala
        .Option(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ): zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
