package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  FileSystemLocationARN,
  AuditDestinationARN,
  FileSystemAssociationStatus,
  FileSystemAssociationARN,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FileSystemAssociationInfo(
    fileSystemAssociationARN: Option[FileSystemAssociationARN] = None,
    locationARN: Option[FileSystemLocationARN] = None,
    fileSystemAssociationStatus: Option[FileSystemAssociationStatus] = None,
    auditDestinationARN: Option[AuditDestinationARN] = None,
    gatewayARN: Option[GatewayARN] = None,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None,
    cacheAttributes: Option[zio.aws.storagegateway.model.CacheAttributes] =
      None,
    endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration
    ] = None,
    fileSystemAssociationStatusDetails: Option[
      Iterable[zio.aws.storagegateway.model.FileSystemAssociationStatusDetail]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo = {
    import FileSystemAssociationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo
      .builder()
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .optionallyWith(
        locationARN.map(value =>
          FileSystemLocationARN.unwrap(value): java.lang.String
        )
      )(_.locationARN)
      .optionallyWith(
        fileSystemAssociationStatus.map(value =>
          FileSystemAssociationStatus.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationStatus)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        endpointNetworkConfiguration.map(value => value.buildAwsValue())
      )(_.endpointNetworkConfiguration)
      .optionallyWith(
        fileSystemAssociationStatusDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemAssociationStatusDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly =
    zio.aws.storagegateway.model.FileSystemAssociationInfo.wrap(buildAwsValue())
}
object FileSystemAssociationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.FileSystemAssociationInfo =
      zio.aws.storagegateway.model.FileSystemAssociationInfo(
        fileSystemAssociationARN.map(value => value),
        locationARN.map(value => value),
        fileSystemAssociationStatus.map(value => value),
        auditDestinationARN.map(value => value),
        gatewayARN.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheAttributes.map(value => value.asEditable),
        endpointNetworkConfiguration.map(value => value.asEditable),
        fileSystemAssociationStatusDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fileSystemAssociationARN: Option[FileSystemAssociationARN]
    def locationARN: Option[FileSystemLocationARN]
    def fileSystemAssociationStatus: Option[FileSystemAssociationStatus]
    def auditDestinationARN: Option[AuditDestinationARN]
    def gatewayARN: Option[GatewayARN]
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ]
    def fileSystemAssociationStatusDetails: Option[List[
      zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly
    ]]
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
    def getLocationARN: ZIO[Any, AwsError, FileSystemLocationARN] =
      AwsError.unwrapOptionField("locationARN", locationARN)
    def getFileSystemAssociationStatus
        : ZIO[Any, AwsError, FileSystemAssociationStatus] =
      AwsError.unwrapOptionField(
        "fileSystemAssociationStatus",
        fileSystemAssociationStatus
      )
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getEndpointNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "endpointNetworkConfiguration",
      endpointNetworkConfiguration
    )
    def getFileSystemAssociationStatusDetails: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fileSystemAssociationStatusDetails",
      fileSystemAssociationStatusDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo
  ) extends zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly {
    override val fileSystemAssociationARN: Option[FileSystemAssociationARN] =
      scala
        .Option(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
    override val locationARN: Option[FileSystemLocationARN] = scala
      .Option(impl.locationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileSystemLocationARN(value)
      )
    override val fileSystemAssociationStatus
        : Option[FileSystemAssociationStatus] = scala
      .Option(impl.fileSystemAssociationStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .FileSystemAssociationStatus(value)
      )
    override val auditDestinationARN: Option[AuditDestinationARN] = scala
      .Option(impl.auditDestinationARN())
      .map(value =>
        zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
      )
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val cacheAttributes
        : Option[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] = scala
      .Option(impl.cacheAttributes())
      .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val endpointNetworkConfiguration: Option[
      zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly
    ] = scala
      .Option(impl.endpointNetworkConfiguration())
      .map(value =>
        zio.aws.storagegateway.model.EndpointNetworkConfiguration.wrap(value)
      )
    override val fileSystemAssociationStatusDetails: Option[List[
      zio.aws.storagegateway.model.FileSystemAssociationStatusDetail.ReadOnly
    ]] = scala
      .Option(impl.fileSystemAssociationStatusDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.FileSystemAssociationStatusDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo
  ): zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly =
    new Wrapper(impl)
}
