package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  RetentionLockTimeInDays,
  PoolName,
  PoolARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PoolInfo(
    poolARN: Option[PoolARN] = None,
    poolName: Option[PoolName] = None,
    storageClass: Option[zio.aws.storagegateway.model.TapeStorageClass] = None,
    retentionLockType: Option[zio.aws.storagegateway.model.RetentionLockType] =
      None,
    retentionLockTimeInDays: Option[RetentionLockTimeInDays] = None,
    poolStatus: Option[zio.aws.storagegateway.model.PoolStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.PoolInfo = {
    import PoolInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.PoolInfo
      .builder()
      .optionallyWith(
        poolARN.map(value => PoolARN.unwrap(value): java.lang.String)
      )(_.poolARN)
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(retentionLockType.map(value => value.unwrap))(
        _.retentionLockType
      )
      .optionallyWith(
        retentionLockTimeInDays.map(value =>
          RetentionLockTimeInDays.unwrap(value): Integer
        )
      )(_.retentionLockTimeInDays)
      .optionallyWith(poolStatus.map(value => value.unwrap))(_.poolStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.PoolInfo.ReadOnly =
    zio.aws.storagegateway.model.PoolInfo.wrap(buildAwsValue())
}
object PoolInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.PoolInfo =
      zio.aws.storagegateway.model.PoolInfo(
        poolARN.map(value => value),
        poolName.map(value => value),
        storageClass.map(value => value),
        retentionLockType.map(value => value),
        retentionLockTimeInDays.map(value => value),
        poolStatus.map(value => value)
      )
    def poolARN: Option[PoolARN]
    def poolName: Option[PoolName]
    def storageClass: Option[zio.aws.storagegateway.model.TapeStorageClass]
    def retentionLockType
        : Option[zio.aws.storagegateway.model.RetentionLockType]
    def retentionLockTimeInDays: Option[RetentionLockTimeInDays]
    def poolStatus: Option[zio.aws.storagegateway.model.PoolStatus]
    def getPoolARN: ZIO[Any, AwsError, PoolARN] =
      AwsError.unwrapOptionField("poolARN", poolARN)
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.TapeStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRetentionLockType
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.RetentionLockType] =
      AwsError.unwrapOptionField("retentionLockType", retentionLockType)
    def getRetentionLockTimeInDays
        : ZIO[Any, AwsError, RetentionLockTimeInDays] = AwsError
      .unwrapOptionField("retentionLockTimeInDays", retentionLockTimeInDays)
    def getPoolStatus
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.PoolStatus] =
      AwsError.unwrapOptionField("poolStatus", poolStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ) extends zio.aws.storagegateway.model.PoolInfo.ReadOnly {
    override val poolARN: Option[PoolARN] = scala
      .Option(impl.poolARN())
      .map(value => zio.aws.storagegateway.model.primitives.PoolARN(value))
    override val poolName: Option[PoolName] = scala
      .Option(impl.poolName())
      .map(value => zio.aws.storagegateway.model.primitives.PoolName(value))
    override val storageClass
        : Option[zio.aws.storagegateway.model.TapeStorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.storagegateway.model.TapeStorageClass.wrap(value))
    override val retentionLockType
        : Option[zio.aws.storagegateway.model.RetentionLockType] = scala
      .Option(impl.retentionLockType())
      .map(value => zio.aws.storagegateway.model.RetentionLockType.wrap(value))
    override val retentionLockTimeInDays: Option[RetentionLockTimeInDays] =
      scala
        .Option(impl.retentionLockTimeInDays())
        .map(value =>
          zio.aws.storagegateway.model.primitives.RetentionLockTimeInDays(value)
        )
    override val poolStatus: Option[zio.aws.storagegateway.model.PoolStatus] =
      scala
        .Option(impl.poolStatus())
        .map(value => zio.aws.storagegateway.model.PoolStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.PoolInfo
  ): zio.aws.storagegateway.model.PoolInfo.ReadOnly = new Wrapper(impl)
}
