package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.IPV4Address
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EndpointNetworkConfiguration(
    ipAddresses: Option[Iterable[IPV4Address]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration = {
    import EndpointNetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration
      .builder()
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            IPV4Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly =
    zio.aws.storagegateway.model.EndpointNetworkConfiguration
      .wrap(buildAwsValue())
}
object EndpointNetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.EndpointNetworkConfiguration =
      zio.aws.storagegateway.model
        .EndpointNetworkConfiguration(ipAddresses.map(value => value))
    def ipAddresses: Option[List[IPV4Address]]
    def getIpAddresses: ZIO[Any, AwsError, List[IPV4Address]] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration
  ) extends zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly {
    override val ipAddresses: Option[List[IPV4Address]] = scala
      .Option(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.IPV4Address(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration
  ): zio.aws.storagegateway.model.EndpointNetworkConfiguration.ReadOnly =
    new Wrapper(impl)
}
