package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCachediScsiVolumesResponse(
    cachediSCSIVolumes: Option[
      Iterable[zio.aws.storagegateway.model.CachediSCSIVolume]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse = {
    import DescribeCachediScsiVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse
      .builder()
      .optionallyWith(
        cachediSCSIVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cachediSCSIVolumes)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse
      .wrap(buildAwsValue())
}
object DescribeCachediScsiVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse =
      zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse(
        cachediSCSIVolumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cachediSCSIVolumes
        : Option[List[zio.aws.storagegateway.model.CachediSCSIVolume.ReadOnly]]
    def getCachediSCSIVolumes: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.CachediSCSIVolume.ReadOnly
    ]] = AwsError.unwrapOptionField("cachediSCSIVolumes", cachediSCSIVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse
  ) extends zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly {
    override val cachediSCSIVolumes: Option[
      List[zio.aws.storagegateway.model.CachediSCSIVolume.ReadOnly]
    ] = scala
      .Option(impl.cachediSCSIVolumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.CachediSCSIVolume.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse
  ): zio.aws.storagegateway.model.DescribeCachediScsiVolumesResponse.ReadOnly =
    new Wrapper(impl)
}
