package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelRetrievalResponse(tapeARN: Option[TapeARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse = {
    import CancelRetrievalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly =
    zio.aws.storagegateway.model.CancelRetrievalResponse.wrap(buildAwsValue())
}
object CancelRetrievalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CancelRetrievalResponse =
      zio.aws.storagegateway.model
        .CancelRetrievalResponse(tapeARN.map(value => value))
    def tapeARN: Option[TapeARN]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse
  ) extends zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly {
    override val tapeARN: Option[TapeARN] = scala
      .Option(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse
  ): zio.aws.storagegateway.model.CancelRetrievalResponse.ReadOnly =
    new Wrapper(impl)
}
