package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStorediScsiVolumesRequest(
    volumeARNs: Iterable[VolumeARN]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest = {
    import DescribeStorediScsiVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest
      .builder()
      .volumeARNs(volumeARNs.map { item =>
        VolumeARN.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest
      .wrap(buildAwsValue())
}
object DescribeStorediScsiVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest =
      zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest(volumeARNs)
    def volumeARNs: List[VolumeARN]
    def getVolumeARNs: ZIO[Any, Nothing, List[VolumeARN]] =
      ZIO.succeed(volumeARNs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest
  ) extends zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest.ReadOnly {
    override val volumeARNs: List[VolumeARN] = impl
      .volumeARNs()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.VolumeARN(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest
  ): zio.aws.storagegateway.model.DescribeStorediScsiVolumesRequest.ReadOnly =
    new Wrapper(impl)
}
