package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBandwidthRateLimitResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse = {
    import DeleteBandwidthRateLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse
      .wrap(buildAwsValue())
}
object DeleteBandwidthRateLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse =
      zio.aws.storagegateway.model
        .DeleteBandwidthRateLimitResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse
  ) extends zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse
  ): zio.aws.storagegateway.model.DeleteBandwidthRateLimitResponse.ReadOnly =
    new Wrapper(impl)
}
