package zio.aws.storagegateway.model
import java.lang.Integer
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListVolumesRequest(
    gatewayARN: Option[GatewayARN] = None,
    marker: Option[Marker] = None,
    limit: Option[PositiveIntObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest = {
    import ListVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListVolumesRequest.ReadOnly =
    zio.aws.storagegateway.model.ListVolumesRequest.wrap(buildAwsValue())
}
object ListVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListVolumesRequest =
      zio.aws.storagegateway.model.ListVolumesRequest(
        gatewayARN.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def gatewayARN: Option[GatewayARN]
    def marker: Option[Marker]
    def limit: Option[PositiveIntObject]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest
  ) extends zio.aws.storagegateway.model.ListVolumesRequest.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Option[PositiveIntObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest
  ): zio.aws.storagegateway.model.ListVolumesRequest.ReadOnly = new Wrapper(
    impl
  )
}
