package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddCacheResponse(gatewayARN: Option[GatewayARN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddCacheResponse = {
    import AddCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddCacheResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.AddCacheResponse.ReadOnly =
    zio.aws.storagegateway.model.AddCacheResponse.wrap(buildAwsValue())
}
object AddCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddCacheResponse =
      zio.aws.storagegateway.model
        .AddCacheResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddCacheResponse
  ) extends zio.aws.storagegateway.model.AddCacheResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddCacheResponse
  ): zio.aws.storagegateway.model.AddCacheResponse.ReadOnly = new Wrapper(impl)
}
