package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Integer,
  NetworkInterfaceId,
  TargetARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeiSCSIAttributes(
    targetARN: Option[TargetARN] = None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    networkInterfacePort: Option[Integer] = None,
    lunNumber: Option[PositiveIntObject] = None,
    chapEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes = {
    import VolumeiSCSIAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
      .builder()
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkInterfacePort.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.networkInterfacePort)
      .optionallyWith(
        lunNumber.map(value =>
          PositiveIntObject.unwrap(value): java.lang.Integer
        )
      )(_.lunNumber)
      .optionallyWith(chapEnabled.map(value => value: java.lang.Boolean))(
        _.chapEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly =
    zio.aws.storagegateway.model.VolumeiSCSIAttributes.wrap(buildAwsValue())
}
object VolumeiSCSIAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VolumeiSCSIAttributes =
      zio.aws.storagegateway.model.VolumeiSCSIAttributes(
        targetARN.map(value => value),
        networkInterfaceId.map(value => value),
        networkInterfacePort.map(value => value),
        lunNumber.map(value => value),
        chapEnabled.map(value => value)
      )
    def targetARN: Option[TargetARN]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def networkInterfacePort: Option[Integer]
    def lunNumber: Option[PositiveIntObject]
    def chapEnabled: Option[Boolean]
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkInterfacePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkInterfacePort", networkInterfacePort)
    def getLunNumber: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("lunNumber", lunNumber)
    def getChapEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("chapEnabled", chapEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ) extends zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly {
    override val targetARN: Option[TargetARN] = scala
      .Option(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.NetworkInterfaceId(value)
      )
    override val networkInterfacePort: Option[Integer] = scala
      .Option(impl.networkInterfacePort())
      .map(value => zio.aws.storagegateway.model.primitives.Integer(value))
    override val lunNumber: Option[PositiveIntObject] = scala
      .Option(impl.lunNumber())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
    override val chapEnabled: Option[Boolean] =
      scala.Option(impl.chapEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ): zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly = new Wrapper(
    impl
  )
}
