package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{NotificationId, FileShareARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotifyWhenUploadedResponse(
    fileShareARN: Option[FileShareARN] = None,
    notificationId: Option[NotificationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse = {
    import NotifyWhenUploadedResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        notificationId.map(value =>
          NotificationId.unwrap(value): java.lang.String
        )
      )(_.notificationId)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly =
    zio.aws.storagegateway.model.NotifyWhenUploadedResponse
      .wrap(buildAwsValue())
}
object NotifyWhenUploadedResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.NotifyWhenUploadedResponse =
      zio.aws.storagegateway.model.NotifyWhenUploadedResponse(
        fileShareARN.map(value => value),
        notificationId.map(value => value)
      )
    def fileShareARN: Option[FileShareARN]
    def notificationId: Option[NotificationId]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getNotificationId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("notificationId", notificationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse
  ) extends zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly {
    override val fileShareARN: Option[FileShareARN] = scala
      .Option(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val notificationId: Option[NotificationId] = scala
      .Option(impl.notificationId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.NotificationId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse
  ): zio.aws.storagegateway.model.NotifyWhenUploadedResponse.ReadOnly =
    new Wrapper(impl)
}
