package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{Marker, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListVolumesResponse(
    gatewayARN: Option[GatewayARN] = None,
    marker: Option[Marker] = None,
    volumeInfos: Option[Iterable[zio.aws.storagegateway.model.VolumeInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse = {
    import ListVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        volumeInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeInfos)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly =
    zio.aws.storagegateway.model.ListVolumesResponse.wrap(buildAwsValue())
}
object ListVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListVolumesResponse =
      zio.aws.storagegateway.model.ListVolumesResponse(
        gatewayARN.map(value => value),
        marker.map(value => value),
        volumeInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: Option[GatewayARN]
    def marker: Option[Marker]
    def volumeInfos
        : Option[List[zio.aws.storagegateway.model.VolumeInfo.ReadOnly]]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getVolumeInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.VolumeInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeInfos", volumeInfos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse
  ) extends zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val volumeInfos
        : Option[List[zio.aws.storagegateway.model.VolumeInfo.ReadOnly]] = scala
      .Option(impl.volumeInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.VolumeInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse
  ): zio.aws.storagegateway.model.ListVolumesResponse.ReadOnly = new Wrapper(
    impl
  )
}
