package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters._
sealed trait SMBSecurityStrategy {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy
}
object SMBSecurityStrategy {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy
  ): zio.aws.storagegateway.model.SMBSecurityStrategy = value match {
    case software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.CLIENT_SPECIFIED =>
      val r = ClientSpecified
      r
    case software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.MANDATORY_SIGNING =>
      val r = MandatorySigning
      r
    case software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.MANDATORY_ENCRYPTION =>
      val r = MandatoryEncryption
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.SMBSecurityStrategy {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy =
      software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object ClientSpecified
      extends zio.aws.storagegateway.model.SMBSecurityStrategy {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy =
      software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.CLIENT_SPECIFIED
  }
  case object MandatorySigning
      extends zio.aws.storagegateway.model.SMBSecurityStrategy {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy =
      software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.MANDATORY_SIGNING
  }
  case object MandatoryEncryption
      extends zio.aws.storagegateway.model.SMBSecurityStrategy {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy =
      software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy.MANDATORY_ENCRYPTION
  }
}
